/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_13;

import java.util.*; import org.shiftone.cache.*;
import lotus.domino.*; import djbuch.kapitel_06.*;
/**
 * 
 * @author Thomas Ekert
 *
 */
public class DJCacheDemo implements Runnable {

	private static final String PASSWORD = "geheim";
	private static final String HOST = null; //"www.djbuch.de"; 		//null fr lokale Session
	private static final String USER = null; //"Thomas Ekert/DJBUCH";	//null fr lokale Session

	public static void main(String[] args) {
		DJCacheDemo cacheDemo = new DJCacheDemo();
		NotesThread nt = new NotesThread(cacheDemo);
		nt.start();
	}

	public void run() {
		Session session = null;
		Database db = null;
		Document doc = null;
		try {
			session = NotesFactory.createSession(HOST, USER, PASSWORD);
			db = session.getDatabase(session.getServerName(), "djbuch/djbuch.nsf");
			Cache cache = DJCache.getCache();
			doc = makeADoc(db);
			DJCacheDocument djDoc = new DJCacheDocument(doc);
			cache.addObject("key", djDoc);
			doc = GC.recycle(doc);
			djDoc = null;
			djDoc = (DJCacheDocument) cache.getObject("key");
			doc = djDoc.createDocument(db);
			doc.save (true,false);
			System.out.println ("\n\nDJCacheDocument: ");
			DemoTools.dumpDoc (djDoc);
			System.out.println ("\n\nlotus.domino.Document: ");
			DemoTools.dumpDoc (doc);
		} catch (Exception e) {
			System.out.println("id = "
					+ (e instanceof NotesException ? ""
							+ ((NotesException) e).id : ""));
			e.printStackTrace();
		} finally {
			GC.recycle(db);
			GC.recycle(session);
		}
	}

	/**
	 * @return
	 * @throws NotesException
	 */
	private Document makeADoc(Database db) throws NotesException {
		Document doc = DemoTools.createDoc(db, "FO_kapitel_13", "Cache",
				"Mein CacheDoc", null);
		doc.replaceItemValue("F_date",db.getParent().createDateTime(Calendar.getInstance().getTime()));
		doc.replaceItemValue ("F_number",new Double (1.7));
		Vector v = new Vector();
		v.add(new Double (2.2));
		v.add(new Double (-3.3));
		doc.appendItemValue("F_numberVector", v);
		v=new Vector ();
		v.add ("Wert 1");
		v.add ("Wert 2");
		doc.appendItemValue ("F_liste", v);
		doc.save(true,false);
		return doc;
	}
}